#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//MetaBall KaleidoscopeMod01.fsh   by   gltracy 
//https://www.shadertoy.com/view/Xs23zm
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// ---- change here ----
const float USE_KALEIDOSCOPE = 1.0;
const float NUM_SIDES = 6.0;

// math const
const float PI = 3.14159265359;
const float DEG_TO_RAD = PI / 180.0;

// -4/9(r/R)^6 + (17/9)(r/R)^4 - (22/9)(r/R)^2 + 1.0
float field( vec2 p, vec2 center, float r ) {
	float d = length( p - center ) / r;
	
	float t   = d  * d;
	float tt  = t  * d;
	float ttt = tt * d;
	
	float v =
		( - 4.0 / 9.0 ) * ttt +
		(  17.0 / 9.0 ) * tt +
		( -22.0 / 9.0 ) * t +
		1.0;
	
	return clamp( v, 0.0, 1.0 );
}

vec2 Kaleidoscope( vec2 uv, float n, float bias ) {
	float angle = PI / n;
	
	float r = length( uv );
	float a = atan( uv.y, uv.x ) / angle;
	
	a = mix( fract( a ), 1.0 - fract( a ), mod( floor( a ), 2.0 ) ) * angle;
	
	return vec2( cos( a ), sin( a ) ) * r;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 ratio = iResolution.xy / min( iResolution.x, iResolution.y );
	vec2 uv = ( fragCoord.xy * 2.0 - iResolution.xy ) / min( iResolution.x, iResolution.y );
	
	// --- Kaleidoscope ---
	uv = mix( uv, Kaleidoscope( uv, NUM_SIDES, iTime * 0.5 ), USE_KALEIDOSCOPE ); 
	
	vec3 final_color = vec3( 0.0 );
	float final_density = 0.0;
	for ( int i = 0; i < 128; i++ ) {
		vec4 noise  = texture( iChannel0, vec2( float( i ) + 0.5, 0.5 ) / 256.0 );
		vec4 noise2 = texture( iChannel0, vec2( float( i ) + 0.5, 9.5 ) / 256.0 );
		
		// velocity
		vec2 vel = noise.xy * 2.0 - vec2( 1.0 );
		
		// center
		vec2 pos = noise.xy;
		pos += iTime * vel * 0.2;
		pos = mix( fract( pos ), 1.0 - fract( pos ), mod( floor( pos ), 2.0 ) );
		
		// remap to screen
		pos = ( pos * 2.0 - 1.0 ) * ratio;
		
		// radius
		float radius = clamp( noise.w, 0.3, 0.8 );
		radius *= radius * 0.4;
		
		// color
		vec3 color = noise2.xyz;
		
		// density
		float density = field( uv, pos, radius );

		// accumulate
		final_density += density;		
		final_color += density * color;
	}

	final_density = clamp( final_density - 0.1, 0.0, 1.0 );
	final_density = pow( final_density, 3.0 );

	fragColor = vec4( final_color * final_density, 1.0 );
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

